#!/usr/bin/perl
#    Univote 1.0 - A simple, universal, webbased poll script
#    Copyright (c) 2001 Arne Bochem <webmaster@heinz99.de>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# INSTALL
#
# 1. Make sure the path to the perl interpreter in line 1 is correct.
# 2. Set the $path variable to a relative path from your cgi-bin to the
#    directory where you will store bar.gif and the CSS files.
#    Example: You put univote.pl to cgi-bin/ and bar.gif to votestuff/.
#             Here $path should be ../votestuff/ [with the trailing slash].
# 3. Copy univote.pl [if you upload it, use ASCII mode] to your cgi-bin
#    or a subdirectory.
# 4. Set chmod 755 or 700. [700 is more secure, but not every server supports
#    it. (suExec/CGIwrap... You know what I mean...)]
# 5. Put bar.gif and error.css to the directory $path points to. If you upload
#    it, use Binary mode.
# 6. You are finished installing the script. Let's create a poll now.
# 6b.You may want to write some CSS stuff into the error.css.

# POLL CREATION
#
# 1. Let's choose the "id" for the poll. This is an integer value greater than
#    zero. For this example we'll choose 1. [Easy, heh?]
# 2. Now we create a file named desc1.txt and write some nice text into it.
#    This text will be displayed above the poll. [Yeah! You can use HTML code
#    here.]
# 3. Put this desc1.txt in the same directory where you put univote.pl. If you
#    upload this file, use ASCII mode.
# 4. Now we'll create a file named voting1.css and put the CSS stuff into it.
#    You could leave it empty, but your poll wouldn't look very good then.
#    If you don't know what CSS means, go to http://www.w3.org/Style/CSS/
#    and try to learn something about it. It's really useful.
# 5. Finished your CSS? Upload/Copy it into the directory $path points to.
#    [Choose your favorite upload mode here. :]]
# 6. Now let's get to the poll itself. Create a file named quest1.txt.
# 7. The first line of this file is the question. We'll use something simple
#    here. Write to the first line: What is your favorite pollscript?
# 8. Ok. Now we'll put the possible answers into the next lines.
#    The second line of the file will be: Univote
#    And the third line: Other
#    That way we have the question "What is your favorite pollscript?" with the
#    possible answers "Univote" and "Other".
#    Of course you could use as much lines as answers as you like.
# 9. Copy/Upload [ASCII mode here.] quest1.txt to the directory, where you put
#    univote.pl.
# 10.Open your favorite webbrowser and enter the URL of univote.pl but append a
#    ?id=1. For example:
#    http://example.host/cgi-bin/pollscripts/univote.pl?id=1
#    Keep in mind that you have to change the ?id=1 to something else, if
#    you choose another id in the beginning. You can have as many parallel
#    polls with different ids as you like.

# FILES
#
# desc[id].txt
#   This file contains a description of the poll. It'll be displayed above the
#   poll itself.
# voting[id].css
#   This file contains the CSS definition for the poll with the corresponding
#   id.
# error.css
#   This file contains the CSS definition for the error page. The errorpage will
#   be displayed when the ?id=[id] part of the url is missing for example. 
# quest[id].txt
#   This file contains the question [line 1] and the possible answers.
# iptabledatabase[id].* [generated automagically]
#   These files contain information about the ips of the voters and blocks every
#   voter for 1h. That way no one will vote three times in a row.
# answertable[id].* [generated automagically]
#   These files contain the number of votes each answer got.

use strict;
use CGI qw(:standard);
use Fcntl;
use SDBM_File;

$, = "\n";

my $id = int(param('id'));
my $blockips = 3600; # Sekunden.
my $path = '../votestuff/'; # Path to CSS and bar.gif
my %iptable;
my %answertable;

open(QUEST, 'quest'.$id.'.txt') or Failure('Poll not existing.');
my $question = <QUEST>;
my @quest = <QUEST>;
close(QUEST);

tie %iptable, 'SDBM_File', 'iptabledatabase'.$id, O_RDWR|O_CREAT, 0700;
tie %answertable, 'SDBM_File', 'answertable'.$id, O_RDWR|O_CREAT, 0700;

open(FILE, 'desc'.$id.'.txt') or Failure('Description missing.');
my $desc = join('', <FILE>);
close(FILE);
(-e $path.'voting'.$id.'.css') or Failure('CSS file missing.');

$desc =~ s/\r//g;
$desc =~ s/\n/<br>/g;

param('answer') ? doVote() : createVoteList();

sub createVoteList
{
	my ($wholenumber, $counter);
	foreach my $value (values %answertable)
	{
		$counter++;
		$wholenumber += $value;
	}
	
	my @questions;
	my $id = 0;
	foreach my $quest (@quest)
	{
		$id++;
		push @questions, [$quest, $answertable{$id-1}, $id, img({-src=>$path.'bar.gif',-height=>16,-width=>(2*getPerCent($wholenumber,$answertable{$id-1})),-alt=>int($answertable{$id-1}).' votes'})];
	}
	@questions = reverse sort { $a->[1] <=> $b->[1] } @questions;
	
	print header(),
		start_html(-title=>"Poll - $question",-style=>{-src=>$path.'voting'.int(param('id')).'.css'},-dtd=>"-//W3C//DTD HTML 4.0 Transitional//EN",-head=>meta({-http_equiv=>'Content-Type',-content=>'text/html; charset=iso-8859-1'})),
		h1({-align=>"center"},"Poll"),
		p($desc),
		start_form({-method=>"POST", -action=>"univote.pl"}),
		hidden({-name=>'id', -default=>int(param('id'))}),
		table({-border=>'0'},
			Tr({-valign=>"middle"},
				[
					th({-colspan=>3,-align=>"left"},[$question]),
					eval
						{
							my @temp;
							foreach my $temporary (@questions)
							{
								push @temp, td(
									[
										'<input type="radio" name="answer" value="'.$temporary->[2].'">',
										$temporary->[0].'('.int($temporary->[1]).')',
										$temporary->[3]
									]
								)
							}
							return @temp;
						},
					td({-colspan=>3},submit(-value=>'Vote')),
				]
			)
		),
		end_form(),
		div({-align=>'center',-style=>'font-size:8pt;font-family:verdana,helvetica,sans-serif;background:#FFFFFF;color:#000000;'},'Copyright &copy;2001 by '.a({-href=>'mailto:univote@heinz99.de'},'Arne Bochem').' ('.a({-href=>'http://www.heinz99.de/',-target=>'_top'},'Heinz99.de').')'), # Don't remove
		end_html();
}
sub doVote
{
	($iptable{$ENV{'REMOTE_ADDR'}} < time()-$blockips) or Failure('You already voted.');
	my $answer = int(param('answer'));
	$answer or Failure('Nothing selected.');
	$answer--;
	$quest[$answer] or Failure('Selection not existing.');
	
	$answertable{$answer}++;
	$iptable{$ENV{'REMOTE_ADDR'}} = time();
	
	print header(),
		start_html(-title=>"Your vote was counted",-style=>{-src=>$path.'voting'.$id.'.css'},-dtd=>"-//W3C//DTD HTML 4.0 Transitional//EN",-head=>meta({-http_equiv=>'Content-Type',-content=>'text/html; charset=iso-8859-1'})),
		h1({-align=>"center"},"Your vote was counted"),
		end_html();
}
sub Failure
{
	my $error = shift();
	print header(),
		start_html(-title=>"Error",-style=>{-src=>$path.'error.css'},-dtd=>"-//W3C//DTD HTML 4.0 Transitional//EN",-head=>meta({-http_equiv=>'Content-Type',-content=>'text/html; charset=iso-8859-1'})),
		h1({-align=>"center"},"Error"),
		p({-align=>"justify"},$error),
		end_html();
	exit();
}
sub getPerCent ($$)
{
	my ($votes,$value) = @_;
	my $result = ($value/$votes)*100 if ($votes);
	$result =~ /^(.*)\.?(.)?/;
	($2 > 4 ? return($1+1) : return(int($1)));
}
